/* - AccelChangeListener -
 * Display the current acceleration value for the corresponding axis.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.AccelerometerPhidget;
import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AccelerationChangeListener;
import com.phidgets.event.AccelerationChangeEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class AccelChangeListener implements AccelerationChangeListener{
    
    private JFrame appFrame;
    private JTextField accel1Txt;
    private JTextField accel2Txt;
    private JTextField accel3Txt;
    
    /** Creates a new instance of AccelChangeListener */
    public AccelChangeListener(JFrame appFrame, JTextField accel1Txt, JTextField accel2Txt, JTextField accel3Txt)
    {
        this.appFrame = appFrame;
        this.accel1Txt = accel1Txt;
        this.accel2Txt = accel2Txt;
        this.accel3Txt = accel3Txt;
    }

    public void accelerationChanged(AccelerationChangeEvent accelerationChangeEvent)
    {
        try
        {
            AccelerometerPhidget sender = (AccelerometerPhidget)accelerationChangeEvent.getSource();
            
            switch(accelerationChangeEvent.getIndex())
            {
                case 0:
                    accel1Txt.setText(Double.toString(sender.getAcceleration(0)));
                    break;
                case 1:
                    accel2Txt.setText(Double.toString(sender.getAcceleration(1)));
                    break;
                case 2:
                    accel3Txt.setText(Double.toString(sender.getAcceleration(2)));
                    break;
                default:
                    JOptionPane.showMessageDialog(appFrame, "Index " + accelerationChangeEvent.getIndex() + " is not a valid axis!", "Axis Index Error", JOptionPane.ERROR_MESSAGE);
                    break;
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
